from pydantic import BaseModel, Field
from enum import Enum


# ------------------------------------------------------------
# ENUMS
# ------------------------------------------------------------
class FrameAnnotationStatus(str, Enum):
    NEW = "new"
    ANNOTATED = "annotated"
    DISCARDED = "discarded"


# ------------------------------------------------------------
# FRAME-LEVEL MODELS (for frames.jsonl)
# ------------------------------------------------------------

# Dataset manifest
# Will give high level info on dataset along with version
class DatasetVersionInfo(BaseModel):
    version: str
    annotation_type: str
    annotation_file: str
    labels: list[str] = Field(default_factory=list)
    num_frames: int = 0
    num_clips: int = 0
    num_videos: int = 0


class DatasetManifest(BaseModel):
    dataset_id: str
    dataset_name: str
    frames_s3_paths: str
    versions: dict[str, DatasetVersionInfo] = Field(default_factory=dict)
    labels: list[str] = Field(default_factory=list)

