from typing import Annotated

from pydantic import Field

from ..utils.xml_models import XMLModel


class BoundingBox(XMLModel):
    xmin: Annotated[int, Field(description="The x-coordinate of the top-left corner of the bounding box")]
    ymin: Annotated[int, Field(description="The y-coordinate of the top-left corner of the bounding box")]
    xmax: Annotated[int, Field(description="The x-coordinate of the bottom-right corner of the bounding box")]
    ymax: Annotated[int, Field(description="The y-coordinate of the bottom-right corner of the bounding box")]
