from pydantic import model_validator
from pydantic.dataclasses import dataclass
from typing_extensions import Self


@dataclass
class FrameExtractorConfig:
    target_fps: int = 5
    frame_skip: int = 0
    skip_similar: float = 1.0

    @model_validator(mode="after")
    def validate_config(self) -> Self:
        if self.target_fps <= 0:
            raise ValueError("Invalid video frame rate")

        return self
