from ..records.nassco.nassco_defects import NasscoDefectRecords
from ..utils.defect_properties import DefectBand, DefectDefinition, DefectRegistry, DefectType

# Create defect definitions with defect_type associated with the defect itself
nassco_defect_config = {
    # Access Point defects (Construction)
    NasscoDefectRecords.access_point_catch_basin: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_cleanout_house: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_cleanout_mainline: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_cleanout_property_line: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_discharge_point: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_end_of_pipe: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_junction_box: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_meter: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.access_point_manhole: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.access_point_other_special_structure: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_tee_connection: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_wastewater_access_device: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_wet_well: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.access_point_other: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    # Structural defects
    NasscoDefectRecords.weld_failure_circumferential: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.weld_failure_longitudinal: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.weld_failure_multiple: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.weld_failure_spiral: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.weld_failure_other: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.surface_damage_aggregate_missing: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_aggregate_projecting: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_aggregate_visible: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_reinforcement_visible: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_reinforcement_projecting: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_reinforcement_corroded: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_roughness_increased: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_surface_spalling: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_spalling_of_coating: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_corrosion: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.surface_damage_other: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.surface_damage_missing_wall: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.crack_longitudinal: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.crack_circumferential: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.crack_multiple: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.crack_spiral: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.crack_hinge_2: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.crack_hinge_3: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.crack_hinge_4: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.fracture_longitudinal: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.fracture_circumferential: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.fracture_multiple: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.fracture_spiral: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.fracture_hinge_2: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.fracture_hinge_3: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.fracture_hinge_4: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.broken: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.broken_soil_visible: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.broken_void_visible: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    # Hole is a special case which actually depends on clock position but following is a workaround.
    NasscoDefectRecords.hole: DefectDefinition(
        defect_type=DefectType.structural,
        bands=[
            DefectBand(severity=4, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=5, min_value_percent=6.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.hole_soil_visible: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.hole_void_visible: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.displaced_brick: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.missing_brick: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.missing_mortar_small: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.missing_mortar_medium: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.missing_mortar_large: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.deformed_flexible_bulging_inverse_curvature: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.deformed_flexible_creasing: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.deformed_flexible_elliptical: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.deformed_brick_bulging_inverse_curvature: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.collapse: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.joint_offset_small: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.joint_offset_small_defective: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.joint_offset_medium: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.joint_offset_medium_defective: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.joint_offset_large: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.joint_offset_large_defective: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.joint_separated_small: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.joint_separated_medium: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.joint_separated_large: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.joint_angular_small: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.joint_angular_medium: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.joint_angular_large: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    # Operational and Maintenance defects
    NasscoDefectRecords.roots_fine_barrel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_fine_lateral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_fine_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_fine_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_tap_barrel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_tap_lateral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_tap_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_tap_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_medium_barrel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_medium_lateral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_medium_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_medium_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_ball_barrel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_ball_lateral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_ball_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.roots_ball_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.vermin_rat: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.vermin_cockroach: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.vermin_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_dripper: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_dripper_barrel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_dripper_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_dripper_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_dripper_lateral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_gusher: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_gusher_barrel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_gusher_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_gusher_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_gusher_lateral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_runner: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_runner_barrel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_runner_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_runner_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_runner_lateral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_stain: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_stain_barrel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_stain_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_stain_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_stain_lateral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_weeper: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_weeper_barrel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_weeper_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_weeper_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.infiltration_weeper_lateral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    # Construction defects
    NasscoDefectRecords.tap_break_in_hammer: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_break_in_activity: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_break_in_abandoned: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_break_in_capped: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_break_in_hammer_defective: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_break_in_intruding: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.tap_factory: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_factory_activity: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_factory_abandoned: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_factory_capped: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_factory_defective: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_factory_intruding: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.tap_rehabilitated: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_rehabilitated_activity: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_rehabilitated_abandoned: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_rehabilitated_capped: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_rehabilitated_defective: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_rehabilitated_intruding: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.tap_saddle: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_saddle_activity: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_saddle_abandoned: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_saddle_capped: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.tap_saddle_defective: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.tap_saddle_intruding: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.point_repair_liner: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.point_repair_liner_defective: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.point_repair_patch: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.point_repair_patch_defective: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.point_repair_replacement: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.point_repair_replacement_defective: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.point_repair_other: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.point_repair_other_defective: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_abandoned_connection: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_annular_space: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_blistered: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_service_cut_shifted: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_detached: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_discoloration: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_defective_end: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_delamination: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_overcut_service: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_resin_slug: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_undercut_service: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_wrinkled: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.lining_feature_other: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    # Miscellaneous defects
    NasscoDefectRecords.miscellaneous_camera_underwater: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_general_observation: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_general_photograph: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_pipe_joint_length_change: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_lining_change: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_material_change: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_survey_abandoned: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_shape_size_change: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_water_mark: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_dye_test_not_visible: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.miscellaneous_dye_test_visible: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.grout_at_location: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    NasscoDefectRecords.grout_test_fail_joint: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.grout_test_fail_lateral: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.grout_test_pass_joint: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.grout_test_pass_lateral: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.grout_test_unable_to_test_joint: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.grout_test_unable_to_test_lateral: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    # Multi-band defects
    NasscoDefectRecords.deformed_rigid: DefectDefinition(
        defect_type=DefectType.structural,
        bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=5.0), DefectBand(severity=5, min_value_percent=6.0, max_value_percent=100.0)],
    ),
    NasscoDefectRecords.deformed_flexible_bulging_round: DefectDefinition(
        defect_type=DefectType.structural,
        bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=10.0), DefectBand(severity=5, min_value_percent=11.0, max_value_percent=100.0)],
    ),
    NasscoDefectRecords.deformed_brick_bulging_round: DefectDefinition(
        defect_type=DefectType.structural,
        bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=5.0), DefectBand(severity=5, min_value_percent=6.0, max_value_percent=100.0)],
    ),
    NasscoDefectRecords.deposits_attached_encrustation: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_attached_grease: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_attached_ragging: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_attached_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_settled_hard_compacted: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_settled_fine: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_settled_gravel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_settled_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_ingress_fine: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_ingress_gravel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.deposits_ingress_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.obstruction_brick_masonry: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.obstruction_pipe_material_in_invert: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.obstruction_intruding_through_wall: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    NasscoDefectRecords.obstruction_wedged_in_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.obstruction_through_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.obstruction_external_pipe_or_cable: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.obstruction_built_into_structure: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.obstruction_construction_debris: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.obstruction_rocks: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.obstruction_other_objects: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.intruding_sealing_material_sealing_ring: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.intruding_seal_material_sealing_ring_hanging: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.intruding_seal_material_sealing_ring_broken: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.intruding_seal_material_sealing_ring_loose: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.intruding_sealing_material_grout: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.intruding_sealing_material_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.line_left: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.line_left_up: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.line_left_down: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.line_right: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.line_right_up: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.line_right_down: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.line_up: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.line_down: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    NasscoDefectRecords.miscellaneous_water_level_sag: DefectDefinition(
        defect_type=DefectType.structural,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=30.0),
            DefectBand(severity=3, min_value_percent=31.0, max_value_percent=50.0),
            DefectBand(severity=4, min_value_percent=51.0, max_value_percent=75.0),
            DefectBand(severity=5, min_value_percent=76.0, max_value_percent=100.0),
        ],
    ),
}

NasscoDefects = DefectRegistry.from_config(NasscoDefectRecords, nassco_defect_config)
