from ..records.wrc.wrc_defects import WrcDefectRecords
from ..utils.defect_properties import DefectBand, DefectDefinition, DefectRegistry, DefectType

wrc_defect_config = {
    WrcDefectRecords.crack_longitudinal: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.crack_circumferential: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.crack_multiple: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.crack_radiates: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.crack_spiral: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.fracture_longitudinal: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.fracture_circumferential: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.fracture_multiple: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.fracture_spiral: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.fracture_radiates: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.broken: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.broken_soil_visible: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.broken_void_visible: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.hole: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.hole_soil_visible: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.hole_void_visible: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.joint_displaced: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.joint_displaced_medium: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.joint_displaced_large: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.open_joint: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.open_joint_medium: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.open_joint_large: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.surface_damage: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.surface_damage_increased_roughness: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.surface_damage_spalling: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.surface_damage_internal_blister_or_bulge: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.surface_damage_aggregate_visible: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.surface_damage_aggregate_projecting_from_surface: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.surface_damage_reinforcement_visible: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.surface_damage_reinforcement_projecting_from_surface: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.surface_damage_reinforcement_corroded: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.surface_damage_corrosion_products: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.surface_damage_other_damage: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.deformed_drain_sewer: DefectDefinition(
        defect_type=DefectType.structural,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=3, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=4, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=5, min_value_percent=21.0, max_value_percent=40.0),
        ],
    ),
    WrcDefectRecords.deformed_vertical: DefectDefinition(
        defect_type=DefectType.structural,
        bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=10.0), DefectBand(severity=5, min_value_percent=11.0, max_value_percent=100.0)],
    ),
    WrcDefectRecords.deformed_horizontal: DefectDefinition(
        defect_type=DefectType.structural,
        bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=10.0), DefectBand(severity=5, min_value_percent=11.0, max_value_percent=100.0)],
    ),
    WrcDefectRecords.collapsed_brickwork_masonry: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.collapsed_drain_sewer: DefectDefinition(
        defect_type=DefectType.structural,
        bands=[
            DefectBand(severity=1, min_value_percent=1.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=3, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=4, min_value_percent=31.0, max_value_percent=40.0),
            DefectBand(severity=5, min_value_percent=41.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_blister_or_internal_bulge: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_lining_detached: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_discolored: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_defective_end: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_longitudinal_wrinkles: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_circumferential_wrinkling: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_spiral_wrinkling: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_complex_multiple_wrinkling: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_at_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_external_bulge: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_end_not_sealed: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_separated_film: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_hole_in_lining: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_resin_missing: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_crack_or_split: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_circumferential_crack_or_split: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_spiral_crack_or_split: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_longitudinal_crack_or_split: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_complex_crack_or_split: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.lining_defect_soft_lining: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.lining_defect_separated_seam_cover: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.weld_failure_circumferential: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.weld_failure_longitudinal: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.weld_failure_spiral: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.point_repair_pipe_replaced: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.point_repair_localised_lining: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.point_repair_injected_mortar: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.point_repair_other_injected_sealing_material: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.point_repair_hole_repaired: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.point_repair_other_repair_to_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.point_repair_localised_lining_of_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.point_repair_other: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.defective_repair_part_of_wall_missing: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_repair_crack_in_material: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_repair_hole_in_material: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_repair_missing_repair_material: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_repair_separation_from_host_pipe: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_repair_excess_material_obstruction: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_repair_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.displaced_brick: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.missing_brick: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.dropped_invert: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.mortar_missing: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.mortar_missing_slight: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.mortar_missing_medium: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.mortar_missing_total: DefectDefinition(defect_type=DefectType.structural, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.attached_deposits_encrustation: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.attached_deposits_grease: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.attached_deposits_fouling: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.attached_deposits_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.settled_deposits_hard_or_compacted: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.settled_deposits_fine: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.settled_deposits_coarse: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.settled_deposits_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.ingress_of_soil_fine_material: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.ingress_of_soil_gravel: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.ingress_of_soil_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.ingress_of_soil: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.ingress_of_soil_sand: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.ingress_of_soil_peat: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.roots: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.roots_fine: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.roots_tap: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.roots_mass: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.infiltration: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.infiltration_seeping: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.infiltration_dripping: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.infiltration_running: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=4, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.infiltration_gushing: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.exfiltration: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.obstruction: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.other_obstacles_brick_or_masonry_in_invert: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.other_obstacles_pipe_material_in_invert: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.other_obstacles_obstacle_protruding_through_wall: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.other_obstacles_other_object_in_invert: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.other_obstacles_through_connection_junction: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.other_obstacles_external_pipe_or_cable: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.other_obstacles_obstacle_built_into_structure: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.other_obstacles_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.connection: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.connection_c: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.defective_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_connection_intruding: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.defective_connection_connecting_pipe_blocked: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.junction: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.junction_closed: DefectDefinition(defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.defective_connection_position_incorrect: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_connection_connecting_pipe_damaged: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_connection_other: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_junction: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=3, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_junction_position_incorrect: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_junction_connecting_pipe_damaged: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_junction_connecting_pipe_blocked: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.defective_junction_other: DefectDefinition(
        defect_type=DefectType.construction, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.sealing_ring_intruding: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.sealing_ring_intruding_and_broken: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.other_sealant_intruding: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=5.0),
            DefectBand(severity=2, min_value_percent=6.0, max_value_percent=10.0),
            DefectBand(severity=3, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=30.0),
            DefectBand(severity=5, min_value_percent=31.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.line_deviates_left: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.line_deviates_right: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.line_deviates_up: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.line_deviates_down: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance,
        bands=[
            DefectBand(severity=1, min_value_percent=0.0, max_value_percent=10.0),
            DefectBand(severity=2, min_value_percent=11.0, max_value_percent=20.0),
            DefectBand(severity=4, min_value_percent=21.0, max_value_percent=100.0),
        ],
    ),
    WrcDefectRecords.change_of_shape: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.change_of_material: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.change_of_lining: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.change_of_pipe_length: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.porous_pipe_material: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.water_level: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.water_level_clear_water: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.water_level_turbid_water: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_manhole: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_inspection_chamber: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_rodding_eye: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_lamphole: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_outfall: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_running_trap: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_buchan_trap: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_catchpit: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_gully: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.start_node_type_oil_separator: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_soakaway: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_winser_trap: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_major_connection_without_manhole: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.start_node_type_other_special_chamber: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_manhole: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_inspection_chamber: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_rodding_eye: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_lamphole: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_outfall: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_buchan_trap: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_running_trap: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_catchpit: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_gully: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.finish_node_type_oil_separator: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_soakaway: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_winser_trap: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_major_connection_without_manhole: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.finish_node_type_other_special_chamber: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.survey_abandoned: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.vermin: DefectDefinition(defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.vermin_cockroaches: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.vermin_cockroaches_observed_in_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.vermin_cockroaches_observed_in_open_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.vermin_cockroaches_observed_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.vermin_rat: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.vermin_rats_observed_in_connection: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.vermin_rats_observed_in_open_joint: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=2, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.vermin_other: DefectDefinition(
        defect_type=DefectType.operational_and_maintenance, bands=[DefectBand(severity=1, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.general_photograph: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.general_remark: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.flow_from_incoming_pipe: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.flow_from_incoming_pipe_clear: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.flow_from_incoming_pipe_wrong_clear_flow: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.flow_from_incoming_pipe_turbid: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.flow_from_incoming_pipe_wrong_foul_flow: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.hazardous_atmosphere_oxygen_deficiency: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.hazardous_atmosphere_hydrogen_sulphide: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.hazardous_atmosphere_methane: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.hazardous_atmosphere_other: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.loss_of_vision_camera_underwater: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.loss_of_vision_silt: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.loss_of_vision_stream: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.loss_of_vision_other: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.video_volume_reference: DefectDefinition(defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]),
    WrcDefectRecords.photograph_volume_reference: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.surface_damage_missing_wall: DefectDefinition(
        defect_type=DefectType.structural, bands=[DefectBand(severity=5, min_value_percent=0.0, max_value_percent=100.0)]
    ),
    WrcDefectRecords.survey_completed_at_backdrop: DefectDefinition(
        defect_type=DefectType.miscellaneous, bands=[DefectBand(severity=0, min_value_percent=0.0, max_value_percent=100.0)]
    ), #Client Defined
}

WrcDefects = DefectRegistry.from_config(WrcDefectRecords, wrc_defect_config)
