from typing import Annotated, List

from pydantic import Field
from typing_extensions import Literal

from ....utils.xml_models import XMLModel
from .annotation_fields import MACPObservation
from .inspection_headers import MACPInspectionHeaders


class MACPInspection(XMLModel):
    type: Annotated[Literal["MACP"], Field(description="The type of the inspection")]
    header: Annotated[MACPInspectionHeaders, Field(description="The header of the MACP inspection")]
    observations: Annotated[List[MACPObservation], Field(description="The observations of the MACP inspection")]

    class Config:
        ignore_fields = ["type"]
        element_name_map = {
            "root": "Report",
            "header": "Header",
            "observations": "annotation",
        }
        flatten_fields = ["observations"]
