from typing import Annotated, List

from pydantic import Field
from typing_extensions import Literal

from ....utils.xml_models import XMLModel
from .annotation_fields import PACPObservation
from .inspection_headers import PACPInspectionHeaders


class PACPInspection(XMLModel):
    type: Annotated[Literal["PACP"], Field(description="The type of the inspection")]
    header: Annotated[PACPInspectionHeaders, Field(description="The header of the PACP inspection")]
    observations: Annotated[List[PACPObservation], Field(description="The observations of the PACP inspection")]

    class Config:
        ignore_fields = ["type"]
        element_name_map = {
            "root": "Report",
            "header": "Header",
            "observations": "annotation",
        }
        flatten_fields = ["observations"]
