from typing import Annotated, Union

from pydantic import Field

from .nassco.macp.inspection import MACPInspection
from .nassco.pacp.inspection import PACPInspection
from .wrc.mainline.inspection import MainlineInspection
from .wrc.manhole.inspection import ManholeInspection

InspectionUnion = Annotated[Union[PACPInspection, MACPInspection, MainlineInspection, ManholeInspection], Field(discriminator="type", description="Union of all inspection types")]
MainlineInspectionUnion = Annotated[Union[MainlineInspection, PACPInspection], Field(discriminator="type", description="Union of all mainline inspection types")]
ManholeInspectionUnion = Annotated[Union[ManholeInspection, MACPInspection], Field(discriminator="type", description="Union of all manhole inspection types")]
