from typing import Annotated, List

from pydantic import Field
from typing_extensions import Literal

from ....utils.xml_models import XMLModel
from .annotation_fields import MainlineObservation
from .inspection_headers import MainlineInspectionHeaders


class MainlineInspection(XMLModel):
    type: Annotated[Literal["Mainline"], Field(description="The type of the inspection")]
    header: Annotated[MainlineInspectionHeaders, Field(description="The header of the Mainline inspection")]
    observations: Annotated[List[MainlineObservation], Field(description="The observations of Mainline inspection")]

    class Config:
        ignore_fields = ["type"]
        element_name_map = {
            "root": "Report",
            "header": "Header",
            "observations": "annotation",
        }
        flatten_fields = ["observations"]
