from typing import Annotated, List

from pydantic import Field
from typing_extensions import Literal

from ....utils.xml_models import XMLModel
from .annotation_fields import ManholeObservation
from .inspection_headers import ManholeInspectionHeaders


class ManholeInspection(XMLModel):
    type: Annotated[Literal["Manhole"], Field(description="The type of the inspection")]
    header: Annotated[ManholeInspectionHeaders, Field(description="The header of the Manhole inspection")]
    observations: Annotated[List[ManholeObservation], Field(description="The observations of Manhole inspection")]

    class Config:
        ignore_fields = ["type"]
        element_name_map = {
            "root": "Report",
            "header": "Header",
            "observations": "annotation",
        }
        flatten_fields = ["observations"]
