from ...utils.abbreviated_enum import AbbreviatedEnum


class NasscoDefectRecords(AbbreviatedEnum):
    """
    Enum for NASSCO defect types.
    """

    # Access Point defects
    access_point_catch_basin = ("Access Point Catch Basin", "ACB")
    access_point_cleanout_house = ("Access Point Cleanout House", "ACOH")
    access_point_cleanout_mainline = ("Access Point Cleanout Mainline", "ACOM")
    access_point_cleanout_property_line = ("Access Point Cleanout Property Line", "ACOP")
    access_point_discharge_point = ("Access Point Discharge Point", "ADP")
    access_point_end_of_pipe = ("Access Point End of Pipe", "AEP")
    access_point_junction_box = ("Access Point Junction Box", "AJB")
    access_point_meter = ("Access Point Meter", "AM")
    access_point_manhole = ("Access Point Manhole", "AMH")
    access_point_other_special_structure = ("Access Point Other Special Structure", "AOC")
    access_point_tee_connection = ("Access Point Tee Connection", "ATC")
    access_point_wastewater_access_device = ("Access Point Wastewater Access Device", "AWA")
    access_point_wet_well = ("Access Point Wet Well", "AWW")
    access_point_other = ("Access Point Other", "AZ")

    # Crack defects
    crack_longitudinal = ("Crack Longitudinal", "CL")
    crack_circumferential = ("Crack Circumferential", "CC")
    crack_multiple = ("Crack Multiple", "CM")
    crack_spiral = ("Crack Spiral", "CS")
    crack_hinge_2 = ("Crack Hinge 2", "CH2")
    crack_hinge_3 = ("Crack Hinge 3", "CH3")
    crack_hinge_4 = ("Crack Hinge 4", "CH4")
    fracture_longitudinal = ("Fracture Longitudinal", "FL")
    fracture_circumferential = ("Fracture Circumferential", "FC")
    fracture_multiple = ("Fracture Multiple", "FM")
    fracture_spiral = ("Fracture Spiral", "FS")
    fracture_hinge_2 = ("Fracture Hinge 2", "FH2")
    fracture_hinge_3 = ("Fracture Hinge 3", "FH3")
    fracture_hinge_4 = ("Fracture Hinge 4", "FH4")
    broken = ("Broken", "B")
    broken_soil_visible = ("Broken Soil Visible", "BSV")
    broken_void_visible = ("Broken Void Visible", "BVV")
    hole = ("Hole", "H")
    hole_soil_visible = ("Hole Soil Visible", "HSV")
    hole_void_visible = ("Hole Void Visible", "HVV")
    deformed_flexible_bulging_inverse_curvature = ("Deformed Flexible Bulging Inverse Curvature", "DFBI")
    deformed_flexible_creasing = ("Deformed Flexible Creasing", "DFC")
    deformed_flexible_elliptical = ("Deformed Flexible Elliptical", "DFE")
    deformed_brick_bulging_inverse_curvature = ("Deformed Brick Bulging Inverse Curvature", "DTBI")
    collapse = ("Collapse", "X")
    joint_offset_small = ("Joint Offset Small", "JOS")
    joint_offset_small_defective = ("Joint Offset Small Defective", "JOSD")
    joint_offset_medium = ("Joint Offset Medium", "JOM")
    joint_offset_medium_defective = ("Joint Offset Medium Defective", "JOMD")
    joint_offset_large = ("Joint Offset Large", "JOL")
    joint_offset_large_defective = ("Joint Offset Large Defective", "JOLD")
    joint_separated_small = ("Joint Separated Small", "JSS")
    joint_separated_medium = ("Joint Separated Medium", "JSM")
    joint_separated_large = ("Joint Separated Large", "JSL")
    joint_angular_small = ("Joint Angular Small", "JAS")
    joint_angular_medium = ("Joint Angular Medium", "JAM")
    joint_angular_large = ("Joint Angular Large", "JAL")
    surface_damage_roughness_increased = ("Surface Damage Roughness Increased", "SRI")
    surface_damage_aggregate_visible = ("Surface Damage Aggregate Visible", "SAV")
    surface_damage_aggregate_projecting = ("Surface Damage Aggregate Projecting", "SAP")
    surface_damage_aggregate_missing = ("Surface Damage Aggregate Missing", "SAM")
    surface_damage_reinforcement_visible = ("Surface Damage Reinforcement Visible", "SRV")
    surface_damage_reinforcement_projecting = ("Surface Damage Reinforcement Projecting", "SRP")
    surface_damage_reinforcement_corroded = ("Surface Damage Reinforcement Corroded", "SRC")
    surface_damage_missing_wall = ("Surface Damage Missing Wall", "SMW")
    surface_damage_surface_spalling = ("Surface Damage Surface Spalling", "SSS")
    surface_damage_spalling_of_coating = ("Surface Damage Spalling of Coating", "SSC")
    surface_damage_corrosion = ("Surface Damage Corrosion", "SCP")
    surface_damage_other = ("Surface Damage Other", "SZ")
    lining_feature_abandoned_connection = ("Lining Feature Abandoned Connection", "LFAC")
    lining_feature_annular_space = ("Lining Feature Annular Space", "LFAS")
    lining_feature_blistered = ("Lining Feature Blistered", "LFB")
    lining_feature_service_cut_shifted = ("Lining Feature Service Cut Shifted", "LFCS")
    lining_feature_detached = ("Lining Feature Detached", "LFD")
    lining_feature_discoloration = ("Lining Feature Discoloration", "LFDC")
    lining_feature_defective_end = ("Lining Feature Defective End", "LFDE")
    lining_feature_delamination = ("Lining Feature Delamination", "LFDL")
    lining_feature_overcut_service = ("Lining Feature Overcut Service", "LFOC")
    lining_feature_resin_slug = ("Lining Feature Resin Slug", "LFRS")
    lining_feature_undercut_service = ("Lining Feature Undercut Service", "LFUC")
    lining_feature_wrinkled = ("Lining Feature Wrinkled", "LFW")
    lining_feature_other = ("Lining Feature Other", "LFZ")
    weld_failure_circumferential = ("Weld Failure Circumferential", "WFC")
    weld_failure_longitudinal = ("Weld Failure Longitudinal", "WFL")
    weld_failure_multiple = ("Weld Failure Multiple", "WFM")
    weld_failure_spiral = ("Weld Failure Spiral", "WFS")
    weld_failure_other = ("Weld Failure Other", "WFZ")
    point_repair_liner = ("Point Repair Liner", "RPL")
    point_repair_liner_defective = ("Point Repair Liner Defective", "RPLD")
    point_repair_patch = ("Point Repair Patch", "RPP")
    point_repair_patch_defective = ("Point Repair Patch Defective", "RPPD")
    point_repair_replacement = ("Point Repair Replacement", "RPR")
    point_repair_replacement_defective = ("Point Repair Replacement Defective", "RPRD")
    point_repair_other = ("Point Repair Other", "RPZ")
    point_repair_other_defective = ("Point Repair Other Defective", "RPZD")
    displaced_brick = ("Displaced Brick", "DB")
    missing_brick = ("Missing Brick", "MB")
    dropped_invert = ("Dropped Invert", "DI")
    grout_at_location = ("Grout at a Location", "GRT")
    grout_test_fail_joint = ("Grout Test Fail Joint", "GTFJ")
    grout_test_fail_lateral = ("Grout Test Fail Lateral", "GTFL")
    grout_test_pass_joint = ("Grout Test Pass Joint", "GTPJ")
    grout_test_pass_lateral = ("Grout Test Pass Lateral", "GTPL")
    grout_test_unable_to_test_joint = ("Grout Test Unable to Test Joint", "GTUJ")
    grout_test_unable_to_test_lateral = ("Grout Test Unable to Test Lateral", "GTUL")
    missing_mortar_small = ("Missing Mortar Small", "MMS")
    missing_mortar_medium = ("Missing Mortar Medium", "MMM")
    missing_mortar_large = ("Missing Mortar Large", "MML")
    roots_fine_barrel = ("Roots Fine Barrel", "RFB")
    roots_fine_lateral = ("Roots Fine Lateral", "RFL")
    roots_fine_connection = ("Roots Fine Connection", "RFC")
    roots_fine_joint = ("Roots Fine Joint", "RFJ")
    roots_tap_barrel = ("Roots Tap Barrel", "RTB")
    roots_tap_lateral = ("Roots Tap Lateral", "RTL")
    roots_tap_connection = ("Roots Tap Connection", "RTC")
    roots_tap_joint = ("Roots Tap Joint", "RTJ")
    roots_medium_barrel = ("Roots Medium Barrel", "RMB")
    roots_medium_lateral = ("Roots Medium Lateral", "RML")
    roots_medium_connection = ("Roots Medium Connection", "RMC")
    roots_medium_joint = ("Roots Medium Joint", "RMJ")
    roots_ball_barrel = ("Roots Ball Barrel", "RBB")
    roots_ball_lateral = ("Roots Ball Lateral", "RBL")
    roots_ball_connection = ("Roots Ball Connection", "RBC")
    roots_ball_joint = ("Roots Ball Joint", "RBJ")
    infiltration_weeper = ("Infiltration Weeper", "IW")
    infiltration_weeper_barrel = ("Infiltration Weeper Barrel", "IWB")
    infiltration_weeper_lateral = ("Infiltration Weeper Lateral", "IWL")
    infiltration_weeper_connection = ("Infiltration Weeper Connection", "IWC")
    infiltration_weeper_joint = ("Infiltration Weeper Joint", "IWJ")
    infiltration_dripper = ("Infiltration Dripper", "ID")
    infiltration_dripper_barrel = ("Infiltration Dripper Barrel", "IDB")
    infiltration_dripper_lateral = ("Infiltration Dripper Lateral", "IDL")
    infiltration_dripper_connection = ("Infiltration Dripper Connection", "IDC")
    infiltration_dripper_joint = ("Infiltration Dripper Joint", "IDJ")
    infiltration_runner = ("Infiltration Runner", "IR")
    infiltration_runner_barrel = ("Infiltration Runner Barrel", "IRB")
    infiltration_runner_lateral = ("Infiltration Runner Lateral", "IRL")
    infiltration_runner_connection = ("Infiltration Runner Connection", "IRC")
    infiltration_runner_joint = ("Infiltration Runner Joint", "IRJ")
    infiltration_gusher = ("Infiltration Gusher", "IG")
    infiltration_gusher_barrel = ("Infiltration Gusher Barrel", "IGB")
    infiltration_gusher_lateral = ("Infiltration Gusher Lateral", "IGL")
    infiltration_gusher_connection = ("Infiltration Gusher Connection", "IGC")
    infiltration_gusher_joint = ("Infiltration Gusher Joint", "IGJ")
    infiltration_stain = ("Infiltration Stain", "IS")
    infiltration_stain_barrel = ("Infiltration Stain Barrel", "ISB")
    infiltration_stain_lateral = ("Infiltration Stain Lateral", "ISL")
    infiltration_stain_connection = ("Infiltration Stain Connection", "ISC")
    infiltration_stain_joint = ("Infiltration Stain Joint", "ISJ")
    vermin_rat = ("Vermin Rat", "VR")
    vermin_cockroach = ("Vermin Cockroach", "VC")
    vermin_other = ("Vermin Other", "VZ")
    tap_break_in_hammer = ("Tap Break-in/Hammer", "TB")
    tap_break_in_activity = ("Tap Break-in Activity", "TBA")
    tap_break_in_abandoned = ("Tap Break-in Abandoned", "TBB")
    tap_break_in_capped = ("Tap Break-in Capped", "TBC")
    tap_break_in_hammer_defective = ("Tap Break-In/Hammer Defective", "TBD")
    tap_break_in_intruding = ("Tap Break-in Intruding", "TBI")
    tap_factory = ("Tap Factory", "TF")
    tap_factory_activity = ("Tap Factory Activity", "TFA")
    tap_factory_abandoned = ("Tap Factory Abandoned", "TFB")
    tap_factory_capped = ("Tap Factory Capped", "TFC")
    tap_factory_defective = ("Tap Factory Defective", "TFD")
    tap_factory_intruding = ("Tap Factory Intruding", "TFI")
    tap_rehabilitated = ("Tap Rehabilitated", "TR")
    tap_rehabilitated_activity = ("Tap Rehabilitated Activity", "TRA")
    tap_rehabilitated_abandoned = ("Tap Rehabilitated Abandoned", "TRB")
    tap_rehabilitated_capped = ("Tap Rehabilitated Capped", "TRC")
    tap_rehabilitated_defective = ("Tap Rehabilitated Defective", "TRD")
    tap_rehabilitated_intruding = ("Tap Rehabilitated Intruding", "TRI")
    tap_saddle = ("Tap Saddle", "TS")
    tap_saddle_activity = ("Tap Saddle Activity", "TSA")
    tap_saddle_abandoned = ("Tap Saddle Abandoned", "TSB")
    tap_saddle_capped = ("Tap Saddle Capped", "TSC")
    tap_saddle_defective = ("Tap Saddle Defective", "TSD")
    tap_saddle_intruding = ("Tap Saddle Intruding", "TSI")
    miscellaneous_camera_underwater = ("Miscellaneous Camera Underwater", "MCU")
    miscellaneous_general_observation = ("Miscellaneous General Observation", "MGO")
    miscellaneous_general_photograph = ("Miscellaneous General Photograph", "MGP")
    miscellaneous_pipe_joint_length_change = ("Miscellaneous Pipe Joint Length Change", "MJL")
    miscellaneous_lining_change = ("Miscellaneous Lining Change", "MLC")
    miscellaneous_material_change = ("Miscellaneous Material Change", "MMC")
    miscellaneous_survey_abandoned = ("Miscellaneous Survey Abandoned", "MSA")
    miscellaneous_shape_size_change = ("Miscellaneous Shape/Size Change", "MSC")
    miscellaneous_water_mark = ("Miscellaneous Water Mark", "MWM")
    miscellaneous_dye_test_not_visible = ("Miscellaneous Dye Test Not Visible", "MYN")
    miscellaneous_dye_test_visible = ("Miscellaneous Dye Test Visible", "MYV")
    deformed_rigid = ("Deformed Rigid", "DR")
    deformed_flexible_bulging_round = ("Deformed Flexible Bulging Round", "DFBR")
    deformed_brick_bulging_round = ("Deformed Brick Bulging Round", "DTBR")
    deposits_attached_encrustation = ("Deposits Attached Encrustation", "DAE")
    deposits_attached_grease = ("Deposits Attached Grease", "DAGS")
    deposits_attached_ragging = ("Deposits Attached Ragging", "DAR")
    deposits_attached_other = ("Deposits Attached Other", "DAZ")
    deposits_settled_hard_compacted = ("Deposits Settled Hard/Compacted", "DSC")
    deposits_settled_fine = ("Deposits Settled Fine", "DSF")
    deposits_settled_gravel = ("Deposits Settled Gravel", "DSGV")
    deposits_settled_other = ("Deposits Settled Other", "DSZ")
    deposits_ingress_fine = ("Deposits Ingress Fine", "DNF")
    deposits_ingress_gravel = ("Deposits Ingress Gravel", "DNGV")
    deposits_ingress_other = ("Deposits Ingress Other", "DNZ")
    obstruction_brick_masonry = ("Obstruction Brick or Masonry", "OBB")
    obstruction_pipe_material_in_invert = ("Obstruction Pipe Material in Invert", "OBM")
    obstruction_intruding_through_wall = ("Obstruction Intruding Through Wall", "OBI")
    obstruction_wedged_in_joint = ("Obstruction Wedged in Joint", "OBJ")
    obstruction_through_connection = ("Obstruction Through Connection", "OBC")
    obstruction_external_pipe_or_cable = ("Obstruction External Pipe or Cable", "OBP")
    obstruction_built_into_structure = ("Obstruction Built into Structure", "OBS")
    obstruction_construction_debris = ("Obstruction Construction Debris", "OBN")
    obstruction_rocks = ("Obstacle/Obstruction Rocks", "OBR")
    obstruction_other_objects = ("Obstacle/Obstruction Other Objects", "OBZ")
    intruding_sealing_material_sealing_ring = ("Intruding Sealing Material Sealing Ring", "ISSR")
    intruding_seal_material_sealing_ring_hanging = ("Intruding Seal Material Sealing Ring Hanging", "ISSRH")
    intruding_seal_material_sealing_ring_broken = ("Intruding Seal Material Sealing Ring Broken", "ISSRB")
    intruding_seal_material_sealing_ring_loose = ("Intruding Seal Material Sealing Loose, Poorly Fitting", "ISSRL")
    intruding_sealing_material_grout = ("Intruding Sealing Material Grout", "ISGT")
    intruding_sealing_material_other = ("Intruding Sealing Material Other", "ISZ")
    line_left = ("Line Left", "LL")
    line_left_up = ("Line Left/Up", "LLU")
    line_left_down = ("Line Left/Down", "LLD")
    line_right = ("Line Right", "LR")
    line_right_up = ("Line Right/Up", "LRU")
    line_right_down = ("Line Right/Down", "LRD")
    line_up = ("Line Up", "LU")
    line_down = ("Line Down", "LD")
    miscellaneous_water_level = ("Miscellaneous Water Level", "MWL")
    miscellaneous_water_level_sag = ("Miscellaneous Water Level Sag", "MWLS")
