from ...utils.abbreviated_enum import AbbreviatedEnum


class WrcDefectRecords(AbbreviatedEnum):
    """
    Enum for WRC defects types.
    """

    crack_longitudinal = ("Crack Longitudinal", "C L")
    crack_circumferential = ("Crack Circumferential", "C C")
    crack_multiple = ("Crack Multiple", "C M")
    crack_radiates = ("Crack radiates", "C R")
    crack_spiral = ("Crack Spiral", "C S")
    fracture_longitudinal = ("Fracture Longitudinal", "F L")
    fracture_circumferential = ("Fracture Circumferential", "F C")
    fracture_multiple = ("Fracture Multiple", "F M")
    fracture_spiral = ("Fracture Spiral", "F S")
    fracture_radiates = ("Fracture Radiates", "F R")
    broken = ("Broken", "B")
    broken_soil_visible = ("Broken Soil Visible", "B SV")
    broken_void_visible = ("Broken Void Visible", "B VV")
    hole = ("Hole", "H")
    hole_soil_visible = ("Hole Soil Visible", "H SV")
    hole_void_visible = ("Hole Void Visible", "H VV")
    joint_displaced = ("Joint Displaced", "JD")
    joint_displaced_medium = ("Joint Displaced Medium", "JD (M)")
    joint_displaced_large = ("Joint Displaced Large", "JD (L)")
    open_joint = ("Open Joint", "OJ")
    open_joint_medium = ("Open Joint Medium", "OJ (M)")
    open_joint_large = ("Open Joint Large", "OJ (L)")
    surface_damage_increased_roughness = ("Surface Damage Increased Roughness", "S W")
    surface_damage_spalling = ("Surface Damage Spalling", "S S")
    surface_damage_internal_blister_or_bulge = ("Surface Damage Internal Blister or Bulge", "S B")
    surface_damage_aggregate_visible = ("Surface Damage Aggregate Visible", "S AV")
    surface_damage_aggregate_projecting_from_surface = ("Surface Damage Aggregate Projecting from Surface", "S AP")
    surface_damage_reinforcement_visible = ("Surface Damage Reinforcement Visible", "S RV")
    surface_damage_reinforcement_projecting_from_surface = ("Surface Damage Reinforcement Projecting from Surface", "S RP")
    surface_damage_reinforcement_corroded = ("Surface Damage Reinforcement Corroded", "S RC")
    surface_damage_corrosion_products = ("Surface Damage Corrosion Products", "S CP")
    surface_damage_other_damage = ("Surface Damage Other Damage", "SZ")
    surface_damage = ("Surface Damage", "S")
    deformed_drain_sewer = ("Deformed Drain/Sewer", "D")
    deformed_vertical = ("Deformed Vertical", "D V")
    deformed_horizontal = ("Deformed Horizontal", "D H")
    collapsed_brickwork_masonry = ("Collapsed Brickwork or masonry", "XB")
    collapsed_drain_sewer = ("Collapsed Drain/Sewer", "XP")
    lining_defect = ("Lining defect", "LX")
    lining_defect_blister_or_internal_bulge = ("Defective lining, blistered lining or internal bulge", "LX B")
    lining_defect_lining_detached = ("Defective lining, lining detached", "LX D")
    lining_defect_discolored = ("Defective lining, discolouration of the lining", "LX C")
    lining_defect_defective_end = ("Defective lining, defective end of lining", "LX E")
    lining_defect_longitudinal_wrinkles = ("Defective lining, longitudinal wrinkling", "LX W L")
    lining_defect_circumferential_wrinkling = ("Defective lining, circumferential wrinkling", "LX W C")
    lining_defect_spiral_wrinkling = ("Defective lining, spiral wrinkling", "LX W H")
    lining_defect_complex_multiple_wrinkling = ("Defective lining, complex (multiple) wrinkling", "LX W M")
    lining_defect_other = ("Defective lining, other", "LX Z")
    lining_defect_at_connection = ("Defective lining, lining defect at connection", "LX CX")
    lining_defect_external_bulge = ("Defective lining, external bulge", "LX EB")
    lining_defect_end_not_sealed = ("Defective lining, end not sealed", "LX ES")
    lining_defect_separated_film = ("Defective lining, separated film", "LX F")
    lining_defect_hole_in_lining = ("Defective lining, hole in lining", "LX H")
    lining_defect_resin_missing = ("Defective lining, resin missing", "LX R")
    lining_defect_crack_or_split = ("Defective lining, crack or split in lining or weld failure", "LX S")
    lining_defect_circumferential_crack_or_split = ("Defective lining, circumferential crack or split in lining or weld failure", "LX S C")
    lining_defect_spiral_crack_or_split = ("Defective lining, spiral crack or split in lining or weld failure", "LX S H")
    lining_defect_longitudinal_crack_or_split = ("Defective lining, Longitudinal crack or split in lining or weld failure", "LX S L")
    lining_defect_complex_crack_or_split = ("Defective lining, complex crack or split in lining or weld failure", "LX S M")
    lining_defect_soft_lining = ("Defective lining, soft lining", "LX SF")
    lining_defect_separated_seam_cover = ("Defective lining, separated seam cover", "LX SS")
    weld_failure_circumferential = ("Weld Failure Circumferential", "WX C")
    weld_failure_longitudinal = ("Weld Failure Longitudinal", "WX L")
    weld_failure_spiral = ("Weld Failure Spiral", "WX S")
    point_repair_pipe_replaced = ("Point repair Pipe replaced", "RP R")
    point_repair_localised_lining = ("Point repair Localised lining", "RP L")
    point_repair_injected_mortar = ("Point repair Injected mortar", "RP I")
    point_repair_other_injected_sealing_material = ("Point repair Other injected sealing material", "RP S")
    point_repair_hole_repaired = ("Point repair Hole repaired", "RP H")
    point_repair_other_repair_to_connection = ("Point repair Other repair to connection", "RP C")
    point_repair_localised_lining_of_connection = ("Point repair Localised lining of connection", "RP T")
    point_repair_other = ("Point repair Other", "RP Z")
    defective_repair_part_of_wall_missing = ("Defective repair Part of wall missing", "RX M")
    defective_repair_crack_in_material = ("Defective repair Crack in material", "RX C")
    defective_repair_hole_in_material = ("Defective repair Hole in material", "RX H")
    defective_repair_missing_repair_material = ("Defective repair Missing repair material", "RX MR")
    defective_repair_separation_from_host_pipe = ("Defective repair Separation from host pipe", "RX S")
    defective_repair_excess_material_obstruction = ("Defective repair Excess material obstruction", "RX XM")
    defective_repair_other = ("Defective repair Other", "RX Z")
    displaced_brick = ("Displaced Brick", "DB")
    missing_brick = ("Missing Brick", "MB")
    dropped_invert = ("Dropped Invert", "DI")
    mortar_missing = ("Mortar Missing", "MM")
    mortar_missing_slight = ("Mortar Missing Slight-between 5 mm and 15 mm", "MM S")
    mortar_missing_medium = ("Mortar Missing Medium-between 15mm and 50mm", "MM M")
    mortar_missing_total = ("Mortar Missing Total-between 50 mm and 100 mm", "MM T")
    attached_deposits_encrustation = ("Attached Deposits Encrustation", "DE E")
    attached_deposits_grease = ("Attached Deposits Grease", "DE G")
    attached_deposits_fouling = ("Attached Deposits Fouling", "DE F")
    attached_deposits_other = ("Attached Deposits Other", "DE Z")
    settled_deposits_hard_or_compacted = ("Settled Deposits Hard or Compacted", "DE C")
    settled_deposits_fine = ("Settled Deposits Fine", "DE S")
    settled_deposits_coarse = ("Settled Deposits Coarse", "DE R")
    settled_deposits_other = ("Settled Deposits Other", "DE X")
    ingress_of_soil_fine_material = ("Ingress of soil Fine Material", "ING F")
    ingress_of_soil_gravel = ("Ingress of soil Gravel", "ING G")
    ingress_of_soil_other = ("Ingress of soil Other", "ING Z")
    ingress_of_soil = ("Ingress of soil", "ING")
    ingress_of_soil_sand = ("Ingress of soil Sand", "ING S")
    ingress_of_soil_peat = ("Ingress of soil Peat", "ING P")
    roots = ("Roots", "R")
    roots_fine = ("Roots Fine", "R F")
    roots_tap = ("Roots Tap", "R T")
    roots_mass = ("Roots Mass", "R M")
    infiltration = ("Infiltration", "I")
    infiltration_seeping = ("Infiltration Seeping", "I S")
    infiltration_dripping = ("Infiltration Dripping", "I D")
    infiltration_running = ("Infiltration Running", "I R")
    infiltration_gushing = ("Infiltration Gushing", "I G")
    exfiltration = ("Exfiltration", "E X")
    other_obstacles_brick_or_masonry_in_invert = ("Other obstacles Brick or Masonry in invert", "OB B")
    other_obstacles_pipe_material_in_invert = ("Other obstacles Pipe Material in Invert", "OB M")
    other_obstacles_obstacle_protruding_through_wall = ("Other obstacles Obstacle protruding through Wall", "OB I")
    other_obstacles_other_object_in_invert = ("Other obstacles Other object in invert", "OB X")
    other_obstacles_through_connection_junction = ("Other obstacles through Connection/Junction", "OB C")
    other_obstacles_external_pipe_or_cable = ("Other obstacles External Pipe or Cable", "OB P")
    other_obstacles_obstacle_built_into_structure = ("Other obstacles Obstacle built into structure", "OB S")
    other_obstacles_other = ("Other Obstacles Other", "OB Z")
    obstruction = ("Obstruction", "OB")
    connection = ("Connection other than junction", "CN")
    connection_c = ("Connection other than junction closed", "CN C")
    defective_connection = ("Connection defective", "CX")
    defective_connection_intruding = ("Connection Intruding", "CX I")
    defective_connection_connecting_pipe_blocked = ("Connection Defective Connecting Pipe blocked", "CX B (I)")
    junction = ("Junction", "JN")
    junction_closed = ("Junction Closed", "JN C")
    defective_connection_position_incorrect = ("Defective Connection Position Incorrect", "CX P (I)")
    defective_connection_connecting_pipe_damaged = ("Defective Connection Connecting Pipe damaged", "CX D (I)")
    defective_connection_other = ("Connection Defective Other", "CX Z")
    defective_junction = ("Junction Defective", "JX")
    defective_junction_position_incorrect = ("Junction Defective Position Incorrect", "JX P")
    defective_junction_connecting_pipe_damaged = ("Junction Defective Connecting Pipe damaged", "JX D")
    defective_junction_connecting_pipe_blocked = ("Junction Defective Connecting pipe blocked", "JX B")
    defective_junction_other = ("Junction Defective Other", "JXZ")
    sealing_ring_intruding = ("Sealing ring Intruding", "SR")
    sealing_ring_intruding_and_broken = ("Sealing ring Intruding and broken", "SR B")
    other_sealant_intruding = ("Other sealant Intruding", "SO")
    line_deviates_left = ("Line of drain/sewer deviates left", "L L")
    line_deviates_right = ("Line of drain/sewer deviates right", "L R")
    line_deviates_up = ("Line of drain/sewer deviates up", "L U")
    line_deviates_down = ("Line of drain/sewer deviates down", "L D")
    change_of_shape = ("Dimension/s of drain/sewer changes ", "SC")
    change_of_material = ("Material of drain/sewer changes", "MC")
    change_of_lining = ("Lining of drain/sewer changes", "LC")

    """ TODO: NEED TO ADD CODES  FOR FOLLOWING DEFECTS AFTER DISCUSSION ON LOGIC
    "SC + [SHAPE CODE]", "MC + [MATERIAL CODE]", "LC + [MATERIAL CODE]" AFTER THE DEFECT CODE FOR THE FOLLOWING DEFECTS"""

    change_of_pipe_length = ("Length of individual pipe formimg drain/sewer changes at this point", "PC")
    porous_pipe_material = ("Pipe material is porous", "PP")
    soil_visible = ("Soil Visible", "SV")
    void_visible = ("Void Visible", "VV")
    water_level = ("Water Level", "WL")
    water_level_clear_water = ("Clean water level", "WL C")
    water_level_turbid_water = ("Turbid water level", "WL T")
    start_node_type_manhole = ("Start node type, Manhole", "MH")
    start_node_type_inspection_chamber = ("Start node type, Inspection Chamber", "IC")
    start_node_type_rodding_eye = ("Start node type, rodding eye", "RE")
    start_node_type_lamphole = ("Start node type, lamphole", "LH")
    start_node_type_outfall = ("Start node type, outfall", "OF")
    start_node_type_running_trap = ("Start node type, running trap", "RG")
    start_node_type_buchan_trap = ("Start node type, Buchan trap", "BN")
    start_node_type_catchpit = ("Start node type, catchpit", "CP")
    start_node_type_gully = ("Start node type, gully", "GY")
    start_node_type_oil_separator = ("Start node type, oil separator", "OS")
    start_node_type_soakaway = ("Start node type, soakaway", "SK")
    start_node_type_winser_trap = ("Start node type, winser trap", "WR")
    start_node_type_major_connection_without_manhole = ("Start node type, mjor connection without manhole", "BR")
    start_node_type_other_special_chamber = ("Start node type, other special chamber", "OC")
    finish_node_type_manhole = ("Finish node type, manhole", "MHF")
    finish_node_type_inspection_chamber = ("Finish node type, inspection chamber", "ICF")
    finish_node_type_rodding_eye = ("Finish node type, rodding eye", "REF")
    finish_node_type_lamphole = ("Finish node type, lamphole", "LHF")
    finish_node_type_outfall = ("Finish node type, outfall", "OFF")
    finish_node_type_running_trap = ("Finish node type, running trap", "RGF")
    finish_node_type_buchan_trap = ("Finish node type, buchan trap", "BNF")
    finish_node_type_catchpit = ("Finish node type, catchpit", "CPF")
    finish_node_type_gully = ("Finish node type, gully", "GYF")
    finish_node_type_oil_separator = ("Finish node type, oil separator", "OSF")
    finish_node_type_soakaway = ("Finish node type, soakaway", "SKF")
    finish_node_type_winser_trap = ("Finish node type, winser trap", "WRF")
    finish_node_type_major_connection_without_manhole = ("Finish node type, major connection without manhole", "BRF")
    finish_node_type_other_special_chamber = ("Finish node type, other special chamber", "OCF")
    survey_abandoned = ("Survey abandoned", "SA")
    vermin = ("Vermin", "V")
    vermin_cockroaches = ("Vermin, cockroaches", "V C")
    vermin_cockroaches_observed_in_connection = ("Vermin, cockroaches observed in connection", "V C C")
    vermin_cockroaches_observed_in_open_joint = ("Vermin, cockroaches observed in open joint", "V C J")
    vermin_cockroaches_observed_other = ("Vermin, cockroaches observed other", "V C Z")
    vermin_rat = ("Vermin, rat", "V R")
    vermin_rats_observed_in_connection = ("Vermin, rats observed in connection", "V R C")
    vermin_rats_observed_in_open_joint = ("Vermin, rats observed in open joint", "V R J")
    vermin_other = ("Vermin, rats observed other", "V R Z")
    general_photograph = ("General Photograph", "GP")
    general_remark = ("General Remark", "REM")
    flow_from_incoming_pipe = ("Flow from incoming pipe", "FW")
    flow_from_incoming_pipe_clear = ("Clear flow from incoming pipe", "FW C")
    flow_from_incoming_pipe_wrong_clear_flow = ("Wrong clear flow from incoming foul pipe", "FW C S")
    flow_from_incoming_pipe_turbid = ("Turbid flow from incoming pipe", "FW T")
    flow_from_incoming_pipe_wrong_foul_flow = ("Wrong turbid flow from incoming surface water pipe", "FW T F")
    hazardous_atmosphere_oxygen_deficiency = ("Hazardous atmosphere Oxygen deficiency", "OD")
    hazardous_atmosphere_hydrogen_sulphide = ("Hazardous atmosphere Hydrogen sulphide", "HS")
    hazardous_atmosphere_methane = ("Hazardous atmosphere Methane", "ME")
    hazardous_atmosphere_other = ("Hazardous atmosphere Other", "GZ")
    loss_of_vision = ("Loss of Vision", "CU")
    loss_of_vision_camera_underwater = ("Loss of vision Camera under water", "CU W")
    loss_of_vision_silt = ("Loss of vision Silt", "CU D")
    loss_of_vision_stream = ("Loss of vision Stream", "CU S")
    loss_of_vision_other = ("Loss of vision Other", "CU Z")
    video_volume_reference = ("Video volume reference new volume", "VVR")
    photograph_volume_reference = ("Photograph volume reference new volume", "PVR")
    surface_damage_missing_wall = ("Surface Damage Missing Wall", "SMW")
    survey_completed_at_backdrop = ("Survey completed at Backdrop", "SCB") #Client Defined
