from typing import Annotated, Optional

from pydantic import BaseModel, Field

from ....records.wrc.directions import Direction
from ....records.wrc.drain_sewer_uses import DrainSewerUse
from ....records.wrc.flow_control_measures import FlowControlMeasure
from ....records.wrc.inspection_mehods import InspectionMethod
from ....records.wrc.inspection_purposes import InspectionPurpose
from ....records.wrc.inspection_stages import InspectionStage
from ....records.wrc.land_ownership_types import LandOwnershipType
from ....records.wrc.lateral_inspection_start_points import LateralInspectionStartPoint
from ....records.wrc.lining_types import LiningType
from ....records.wrc.location_types import LocationTypeHighway, LocationTypeSewerage
from ....records.wrc.materials import Material
from ....records.wrc.pre_cleaned_options import PreCleanedOptions
from ....records.wrc.shapes import Shape
from ....records.wrc.temperature_options import Temperature
from ....records.wrc.video_image_formats import VideoImageFormat
from ....records.wrc.video_image_location_systems import VideoImageLocationSystem
from ....records.wrc.video_image_storage_media_options import VideoImageStorageMedia
from ....records.wrc.weather_options import WeatherOptions


class ClientDefinedField(BaseModel):
    name: Annotated[Optional[str], Field(default=None, description="Enter the name of the client-defined field.")]
    value: Annotated[Optional[str], Field(default=None, description="Enter the value for the client-defined field.")]


class MainlineInspectionHeaders(BaseModel):
    client: Annotated[Optional[str], Field(default=None, description="Enter the name of the sewerage undertaker, highway authority, or other owner of the drain or sewer.")]
    name_of_surveyor: Annotated[Optional[str], Field(default=None, description="Enter the name of the person responsible for completing the survey.")]
    client_job_reference: Annotated[Optional[str], Field(default=None, description="Enter the client's job reference code.")]
    contractor_job_reference: Annotated[Optional[str], Field(default=None, description="Enter the contractor's job reference code.")]
    drainage_area: Annotated[Optional[str], Field(default=None, description="When provided by the client, this should be entered here.")]
    division_district: Annotated[Optional[str], Field(default=None, description="Enter an appropriate district/division code.")]
    pipeline_length_reference: Annotated[Optional[str], Field(default=None, description="Enter the pipeline length reference derived from the upstream manhole of each survey.")]
    survey_date: Annotated[Optional[str], Field(default=None, description="Enter the survey date in the order day, month, year (YYYYMMDD).")]
    survey_time: Annotated[Optional[str], Field(default=None, description="Enter the time at the commencement of survey of drain/sewer length (24 hr format HH:MM).")]
    location_street_name: Annotated[Optional[str], Field(default=None, description="Enter the street name through which the drain/sewer is situated.")]
    location_town_or_village: Annotated[Optional[str], Field(default=None, description="Enter a town, village or area where the drain/sewer is located.")]
    location_type_code: Annotated[
        Optional[LocationTypeSewerage | LocationTypeHighway], Field(default=None, description="Enter the appropriate code for the location of the drain/sewer.")
    ]
    land_ownership: Annotated[Optional[LandOwnershipType], Field(default=None, description="Enter the owner of the land on which the survey is carried out.")]
    start_node_reference: Annotated[Optional[str], Field(default=None, description="Enter reference in accordance with manhole no.")]
    start_node_coordinate: Annotated[Optional[str], Field(default=None, description="If the client specifies the use of a coordinate, then enter the XY coordinates.")]
    node1_reference: Annotated[
        Optional[str],
        Field(
            default=None,
            description="Where a survey of the lateral is carried out from the main line, enter the node reference from which the camera started the survey of the main line.",
        ),
    ]
    node1_coordinate: Annotated[Optional[str], Field(default=None, description="If the client specifies the use of a coordinate, then enter the XY coordinates.")]
    depth_at_start_node: Annotated[
        Optional[str], Field(default=None, description="Enter in metres the distance between the cover level of the manhole and the invert level of the pipe/sewer being surveyed.")
    ]
    finish_node_reference: Annotated[Optional[str], Field(default=None, description="Enter a reference in accordance with the manhole/node.")]
    depth_at_finish_node: Annotated[Optional[str], Field(default=None, description="Enter the depth of the finish manhole in the same way as the start manhole.")]
    node2_coordinate: Annotated[Optional[str], Field(default=None, description="If the client specifies the use of a coordinate, then enter the XY coordinates.")]
    node3_reference: Annotated[
        Optional[str], Field(default=None, description="Enter a reference in accordance with the node (Node 3 reference is only used when carrying out a lateral survey).")
    ]
    node3_coordinate: Annotated[Optional[str], Field(default=None, description="If the client specifies the use of a coordinate, then enter the XY coordinates.")]
    lateral_inspection_start_point: Annotated[
        Optional[LateralInspectionStartPoint], Field(default=None, description="Enter the start point of the inspection (Codes for Lateral inspection start point).")
    ]
    longitudinal_location_of_start_of_lateral: Annotated[
        Optional[str], Field(default=None, description="Enter the length in metres of the start point of the lateral survey from Node 1.")
    ]
    circumferential_location_of_start_of_lateral: Annotated[
        Optional[str], Field(default=None, description="Enter the clock reference of the connection of the lateral being surveyed.")
    ]
    use_of_drain_sewer: Annotated[Optional[DrainSewerUse], Field(default=None, description="Enter codes to define the use of the drain/sewer (Codes for Drain/Sewer).")]
    type_of_drain_sewer: Annotated[Optional[str], Field(default=None, description="Enter codes for the type of drain/sewer (Codes for types of drain/sewer).")]
    direction: Annotated[Optional[Direction], Field(default=None, description="Enter codes for the direction of survey in relation to flow (Codes for direction).")]
    height_or_diameter: Annotated[Optional[str], Field(default=None, description="Enter the dimensions of either drain/sewer height or diameter (If circular, in millimetres).")]
    width: Annotated[Optional[str], Field(default=None, description="Enter the maximum drain/sewer width.")]
    shape: Annotated[Optional[Shape], Field(default=None, description="Enter the codes to describe the drain/sewer shape (Codes for Shapes).")]
    material: Annotated[Optional[Material], Field(default=None, description="Enter codes for the drain/sewer material (Codes for Material).")]
    lining_material: Annotated[
        Optional[str], Field(default=None, description="Where the drain/sewer has been relined, enter codes listed under 'Material' to define the lining material.")
    ]
    lining_type: Annotated[Optional[LiningType], Field(default=None, description="Where a drain/sewer has been lined, record the method of the lining (Codes for Lining type).")]
    pre_cleaned: Annotated[
        Optional[PreCleanedOptions],
        Field(
            default=None,
            description="Enter Y if pre-cleaning was carried out, N if it was not and Z if not known (Y or N shall only be entered if the information is definitely known).",
        ),
    ]
    general_remarks: Annotated[Optional[str], Field(default=None, description="Enter any general information relevant to the survey of the complete drain/sewer.")]
    critical_strategic_drain_sewer: Annotated[Optional[str], Field(default=None, description="Enter appropriate code for the survey purpose.")]
    purpose_of_inspection: Annotated[
        Optional[InspectionPurpose], Field(default=None, description="Enter an appropriate code for the survey purpose (Codes for purpose of inspection).")
    ]
    inspection_stage: Annotated[Optional[InspectionStage], Field(default=None, description="Enter the code for inspection stage (Codes for inspection stage).")]
    flow_control_measures: Annotated[
        Optional[FlowControlMeasure],
        Field(default=None, description="Enter the measures taken to deal with the flow at the time of the inspection (Codes for flow control measures)."),
    ]
    weather: Annotated[Optional[WeatherOptions], Field(default=None, description="Enter an appropriate code for weather (Codes for weather).")]
    temperature: Annotated[Optional[Temperature], Field(default=None, description="Enter the temperature in Celsius or as a code (Codes for Temperature).")]
    pipe_unit_length: Annotated[
        Optional[float],
        Field(
            default=None,
            description=(
                "Enter the length in metres of normal pipe "
                "(Be careful not to measure the rocker pipe adjacent to a manhole as it is normal to use only part of a pipe unit in this location)."
            ),
        ),
    ]
    expected_length: Annotated[
        Optional[float],
        Field(
            default=None,
            description=(
                "Enter the distance once the survey is complete, where the whole length is surveyed, "
                "between the exit of the start manhole and the entrance to the finish manhole (Note that this length is not the length between manhole centrelines. "
                "The accuracy required is generally ±1 or ±0.3 m, whichever is the greater)."
            ),
        ),
    ]
    year_constructed: Annotated[Optional[int], Field(default=None, description="Enter the actual year the drain/sewer was constructed (Enter Z if the year is not known).")]
    method_of_inspection: Annotated[Optional[InspectionMethod], Field(default=None, description="Enter the codes for the method of inspection (Codes for method of inspection).")]
    standard: Annotated[Optional[str], Field(default=None, description="Enter the version of the standard used to record the data.")]
    video_image_storage_media: Annotated[
        Optional[VideoImageStorageMedia], Field(default=None, description="Enter the type of media used for recording images (Codes for video images storage media).")
    ]
    video_image_location_system: Annotated[
        Optional[VideoImageLocationSystem],
        Field(default=None, description="For moving images, the method of recording the position on the video media should be recorded (Codes for Video Image Location System)."),
    ]
    video_image_format: Annotated[Optional[VideoImageFormat], Field(default=None, description="Enter the type of media used for storing videos (Codes for video image format).")]
    video_image_file_name: Annotated[Optional[str], Field(default=None, description="Enter the name of the file as stored.")]
    video_volume_reference: Annotated[Optional[str], Field(default=None, description="Enter the reference number of the volume.")]
    photograph_image_format: Annotated[Optional[str], Field(default=None, description="Enter the type of media used for storing images.")]
    photograph_volume_reference: Annotated[Optional[str], Field(default=None, description="Enter the reference number of the film.")]
    client_defined_fields: Annotated[Optional[list[ClientDefinedField]], Field(default=None, description="These fields are to be used where specified by the client.")]
