from typing import Annotated, Optional

from pydantic import BaseModel, Field

from ....records.wrc.materials import Material


class ManholeObservation(BaseModel):
    video_reference: Annotated[
        Optional[str],
        Field(
            default=None,
            description="The time reference to the location of entry on the video recording.",
        ),
    ]
    photograph_reference: Annotated[
        Optional[str],
        Field(
            default=None,
            description="Wherever a still image or photograph is taken of the feature, a reference should be given.",
        ),
    ]
    distance: Annotated[
        Optional[float],
        Field(
            default=None,
            description="Defect/observation observed on the number displayed on the distance counter.",
        ),
    ]
    continuous_defect: Annotated[
        Optional[str],
        Field(
            default=None,
            description="This is used to indicate the start, change or finish of a continuous code by use of the letters S, C or F.",
        ),
    ]
    component: Annotated[
        Optional[str],
        Field(
            default=None,
            description="The Manhole Component Defect Section only records defects for the chimney, cone, wall, bench and channel.",
        ),
    ]
    code: Annotated[
        Optional[str],
        Field(
            default=None,
            description="The defect/observation code are entered.",
        ),
    ]
    joint: Annotated[
        Optional[str],
        Field(
            default=None,
            description=(
                "The letter 'J' should be added to the appropriate defect code where"
                "the defect starts and ends within 0.2m of a single pipe joint or if the defect is at or on the joint."
            ),
        ),
    ]
    material: Annotated[
        Optional[Material],
        Field(
            default=None,
            description="Where the codes 'MC' or 'LC' are used, the code for the new material or lining material needs to be entered.",
        ),
    ]
    band: Annotated[
        Optional[str],
        Field(
            default=None,
            description=(
                "The descriptions of certain codes allow the feature to be quantified based on certain bands, e.g Medium (M) or Large (L). The code's quantification is entered."
            ),
        ),
    ]
    severity: Annotated[
        Optional[int],
        Field(
            default=None,
            description="Grade or Severity associated with the respective defect/observation.",
        ),
    ]
    value_1st_dimension: Annotated[
        Optional[str],
        Field(
            default=None,
            description="Physical measurements or manhole/node reference information are entered.",
        ),
    ]
    value_2nd_dimension: Annotated[
        Optional[str],
        Field(
            default=None,
            description="Physical measurements or manhole/node reference information are entered.",
        ),
    ]
    value_percent: Annotated[
        Optional[float],
        Field(
            default=None,
            description="Where a code requires a percentage value.",
        ),
    ]
    circumferential_location_from: Annotated[
        Optional[int],
        Field(
            default=None,
            description="The defect/observation covers a range of clock positions that are entered.",
        ),
    ]
    circumferential_location_to: Annotated[
        Optional[int],
        Field(
            default=None,
            description="Defect clock position is entered. The defect/observation covers a range of clock position that are entered.",
        ),
    ]
    remarks: Annotated[
        Optional[str],
        Field(
            default=None,
            description="Enter appropriate details about the defect/observation.",
        ),
    ]
