from typing import Annotated, List, Optional

from pydantic import BaseModel, Field

from ....records.wrc.cover_shapes import CoverShape
from ....records.wrc.flow_control_measures import FlowControlMeasure
from ....records.wrc.inspection_mehods import InspectionMethod
from ....records.wrc.inspection_purposes import InspectionPurpose
from ....records.wrc.inspection_stages import InspectionStage
from ....records.wrc.land_ownership_types import LandOwnershipType
from ....records.wrc.location_types import LocationTypeHighway, LocationTypeSewerage
from ....records.wrc.manhole_uses import ManholeUse
from ....records.wrc.materials import Material
from ....records.wrc.node_types import NodeType
from ....records.wrc.pre_cleaned_options import PreCleanedOptions
from ....records.wrc.shapes import Shape
from ....records.wrc.steps_materials import StepsMaterial
from ....records.wrc.temperature_options import Temperature
from ....records.wrc.vertical_reference_points import VerticalReferencePoint
from ....records.wrc.video_image_formats import VideoImageFormat
from ....records.wrc.video_image_location_systems import VideoImageLocationSystem
from ....records.wrc.video_image_storage_media_options import VideoImageStorageMedia
from ....records.wrc.weather_options import WeatherOptions


class ClientDefinedField(BaseModel):
    name: Annotated[Optional[str], Field(default=None, description="Enter the name of the client-defined field")]
    value: Annotated[Optional[str], Field(default=None, description="Enter the value for the client-defined field")]


class ManholeInspectionHeaders(BaseModel):
    client: Annotated[
        Optional[str], Field(default=None, description="Enter the name of the sewerage undertaker, highway authority, Highways Agency Region or other owner of the drain or sewer.")
    ]
    name_of_surveyor: Annotated[Optional[str], Field(default=None, description="Enter the name of the person responsible for completing the survey")]
    client_job_reference: Annotated[Optional[str], Field(default=None, description="Enter the client's job reference code")]
    contractor_job_reference: Annotated[Optional[str], Field(default=None, description="Enter the contractor's job reference code")]
    drainage_area: Annotated[Optional[str], Field(default=None, description="When provided by the client, this should be entered here.")]
    division_district: Annotated[Optional[str], Field(default=None, description="Enter an appropriate district/division code")]
    node_type: Annotated[Optional[NodeType], Field(default=None, description="Enter the type of node")]
    manhole_node_reference: Annotated[Optional[str], Field(default=None, description="Enter a reference in accordance with the manhole/node")]
    manhole_node_coordinates: Annotated[Optional[str], Field(default=None, description="This consists of the Ordnance Survey map number and 100-meter grid coordinates")]
    date: Annotated[Optional[str], Field(default=None, description="Enter the survey date in the order day, month, year")]
    time_24_hr: Annotated[Optional[str], Field(default=None, description="Enter the time at the commencement of survey of drain/sewer length.")]
    location_street_name: Annotated[Optional[str], Field(default=None, description="Enter “street name” through which the drain/sewer is situated.")]
    location_town_or_village: Annotated[Optional[str], Field(default=None, description="Enter a town, village or area where the drain/sewer is located.")]
    location_type_code: Annotated[
        Optional[LocationTypeSewerage | LocationTypeHighway], Field(default=None, description="Enter the appropriate code for the location of the drain/sewer.")
    ]
    land_ownership: Annotated[Optional[LandOwnershipType], Field(default=None, description="This field is only to be used on the instruction of the client")]
    vertical_reference_point: Annotated[Optional[VerticalReferencePoint], Field(default=None, description="Enter an appropriate vertical reference point code used in the survey")]
    circumferential_reference_point: Annotated[
        Optional[str], Field(default=None, description="The circumferential reference point is defined as being the lowest outgoing pipeline")
    ]
    use_of_manhole_inspection_chamber: Annotated[Optional[ManholeUse], Field(default=None, description="Enter codes to define the use of the manhole/inspection chamber")]
    general_remarks: Annotated[Optional[str], Field(default=None, description="Enter any general information relevant to the survey")]
    shape_of_cover: Annotated[Optional[Shape], Field(default=None, description="Enter codes to describe the manhole/inspection chamber cover shape")]
    material_of_cover: Annotated[Optional[Material], Field(default=None, description="Enter codes for the cover material.")]
    width_of_cover: Annotated[Optional[float], Field(default=None, description="Enter the width of the cover of the manhole/inspection chamber in millimetres")]
    breadth_of_cover: Annotated[Optional[float], Field(default=None, description="Enter the breadth of the cover of the manhole/inspection chamber in millimetres")]
    cover_level: Annotated[Optional[float], Field(default=None, description="Enter the level of the cover of the manhole/inspection chamber in metres.")]
    shape_of_access: Annotated[Optional[CoverShape], Field(default=None, description="Enter the shape of access to the manhole/inspection chamber")]
    width_of_access: Annotated[
        Optional[float], Field(default=None, description="Enter the width of the smallest part of the access into the manhole/inspection chamber in millimetres.")
    ]
    breadth_of_access: Annotated[
        Optional[float], Field(default=None, description="Enter the breadth of the smallest part of the access into the manhole/inspection chamber in millimetres.")
    ]
    material: Annotated[Optional[Material], Field(default=None, description="Enter codes for manhole/inspection chamber material")]
    material_of_steps: Annotated[
        Optional[StepsMaterial], Field(default=None, description="Enter the code for the material of steps or ladder used in the manhole/inspection chamber:")
    ]
    pre_cleaned: Annotated[
        Optional[PreCleanedOptions],
        Field(default=None, description="State whether cleaning was carried out prior to the survey. Enter Y if pre-cleaning was carried out, N if it was not and Z if not known"),
    ]
    strategic_drains_sewer: Annotated[Optional[str], Field(default=None, description="Enter the sewer category code A, B or C as defined in the Sewer Risk Management website")]
    purpose_of_inspection: Annotated[Optional[InspectionPurpose], Field(default=None, description="Enter an appropriate code for the survey purpose")]
    inspection_stage: Annotated[Optional[InspectionStage], Field(default=None, description="Enter the code for inspection stage")]
    flow_control_measures: Annotated[Optional[FlowControlMeasure], Field(default=None, description="Enter the measures taken to deal with the flow at the time of the inspection")]
    weather: Annotated[Optional[WeatherOptions], Field(default=None, description="Enter an appropriate code for weather")]
    temperature: Annotated[Optional[Temperature], Field(default=None, description="Enter the temperature in Celsius or as a code")]
    chamber_unit_length: Annotated[Optional[float], Field(default=None, description="Enter the length in millimetres of the individual manhole/inspection chamber ring unit.")]
    year_constructed: Annotated[Optional[int], Field(default=None, description="Enter the actual year the drain/sewer was constructed")]
    method_of_inspection: Annotated[Optional[InspectionMethod], Field(default=None, description="Enter the codes for the method of inspection")]
    standard: Annotated[Optional[str], Field(default=None, description="Enter the version of the standard used to record the data.")]
    video_image_storage_media: Annotated[Optional[VideoImageStorageMedia], Field(default=None, description="Enter the type of media used for recording images")]
    video_image_location_system: Annotated[
        Optional[VideoImageLocationSystem], Field(default=None, description="For moving images, the method of recording the position on the video media should be recorded")
    ]
    video_image_format: Annotated[Optional[VideoImageFormat], Field(default=None, description="Enter the type of media used for storing videos")]
    video_image_file_name: Annotated[Optional[str], Field(default=None, description="Enter the name of the file as stored.")]
    video_volume_reference: Annotated[Optional[str], Field(default=None, description="Enter the reference number of the volume")]
    photograph_image_format: Annotated[Optional[str], Field(default=None, description="Enter the type of media used for storing images")]
    photograph_volume_reference: Annotated[Optional[str], Field(default=None, description="Enter the reference number of the film")]
    client_defined_fields: Annotated[Optional[List[ClientDefinedField]], Field(default_factory=list, description="These fields are to be used where specified by the client")]
