from ...utils.abbreviated_enum import AbbreviatedEnum


class CoverFrameFit(AbbreviatedEnum):
    good = (
        "Good – The cover fits satisfactorily onto the frame and the total gap between the cover and the frame rim is less than or equal to 0.25 inches (6 mm).",
        "G",
    )
    oversized = (
        "Oversized – The cover is too large and cannot seat properly on the frame bearing surface.",
        "O",
    )
    rocks_or_wobbles = (
        "Rocks/Wobbles – The cover does not sit properly on the frame and is unstable",
        "R",
    )
    undersized = (
        "Undersized – The cover is too small and the gap between the edge of the cover and the frame rim is greater than 0.25 inches (6 mm).",
        "U",
    )
