from ...utils.abbreviated_enum import AbbreviatedEnum


class CoverInsertCondition(AbbreviatedEnum):
    sound = ("No significant defects", "Sound")
    corroded = ("Insert shows signs of corrosion", "Corroded")
    cracked = ("Insert is significantly damaged", "Cracked")
    insert_fell = ("The insert is in the bottom of the manhole and was not retrieved", "Insert Fell")
    leaking = (
        "Evidence that the cover insert is leaking, or that the drain valve is damaged",
        "Leaking",
    )
    poor_fitting = (
        "The cover insert does not seal properly to the cover or frame, a gap exists between the insert and the frame clear opening",
        "Poor Fitting",
    )
