from ...utils.abbreviated_enum import AbbreviatedEnum


class LocationTypeSewerage(AbbreviatedEnum):
    road = ("Road", "RD")
    footway_beside_road = ("A footway beside a road", "FWY")
    verge = ("Verge", "VG")
    pedestrian_area = ("Other pedestrian area", "PD")
    fields = ("Fields (farmland and public open space)", "FLD")
    property_with_buildings = ("Property with buildings", "PR")
    gardens = ("Gardens (within private property)", "GDN")
    under_permanent_building = ("Under permanent building", "BLG")
    woodland = ("Woodland", "WLD")
    difficult_access = ("Difficult access", "DIF")
    under_waterway = ("Under a waterway", "WWY")
    other = ("Other", "Z")


class LocationTypeHighway(AbbreviatedEnum):
    left_outside_verge = ("Left Outside Verge", "XS1")
    left_footway = ("Left Footway", "XS2")
    left_verge = ("Left Verge", "XS3")
    lane1_hard_shoulder = ("Lane1 - Hard shoulder", "XS4")
    lane2_left_lane = ("Lane2 - Left lane", "XS5")
    lane3_central_lane = ("Lane3 - Central lane", "XS6")
    lane4_right_lane = ("Lane4 - Right lane", "XS7")
    right_verge = ("Right Verge", "XS8")
    right_footway = ("Right Footway", "XS9")
    right_outside_verge = ("Right Outside Verge", "XS0")
    right_turning_lane = ("Right turning lane", "XSE")
    slip_road = ("Slip road", "XSQ")
    bus_lane = ("Bus lane", "XSR")
    crawler_lane = ("Crawler lane", "XST")
    left_turning_lane = ("Left turning lane", "XSW")
    any_other_option = ("Any other option", "XSY")
